package net.w_horse.excelpojo;

import java.beans.PropertyDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;

import net.w_horse.excelpojo.annotation.Bean;
import net.w_horse.excelpojo.annotation.ExcelPOJOAnnotationParser;
import net.w_horse.excelpojo.bean.Utils;
import net.w_horse.excelpojo.excel.AbstractCellSeeker;
import net.w_horse.excelpojo.excel.ConstantValueCellSeeker;
import net.w_horse.excelpojo.excel.HorizontalRepeatsSeeker;
import net.w_horse.excelpojo.excel.LabeledCellSeeker;
import net.w_horse.excelpojo.excel.MappedCellSeeker;
import net.w_horse.excelpojo.excel.PointedCellSeeker;
import net.w_horse.excelpojo.excel.SheetNotFoundException;
import net.w_horse.excelpojo.excel.VerticalRepeatsSeeker;
import net.w_horse.excelpojo.xml.tag.RetrieveType;

import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

/**
 * ExcelPOJOԂ̓ǂݍ/݂sNX
 *
 * @author kawahara
 *
 */
public class ExcelPOJOBridge {

	private String sheetName;
	private String targetClass = "";

	private HashMap<String, AbstractCellSeeker> targetClassProperties = new HashMap<String, AbstractCellSeeker>();

	private AbstractCellSeeker cellSeeker;

	public ExcelPOJOBridge() {
	}

	/**
	 * XMLɂݒt@Cgp
	 * ExcelPOJOԂ̃}bsOsۂɎgpRXgN^<br>
	 *
	 * @param targetClass ǂݍ񂾏i[NX
	 * @throws ExcelPOJOException Ame[Vw肳ĂȂꍇ
	 */
	public ExcelPOJOBridge(Class<?> targetClass) throws ExcelPOJOException {
		Bean beanAnnotation = targetClass.getAnnotation(Bean.class);
		if (beanAnnotation == null) {
			throw new ExcelPOJOException("There is no annotation specified on the target class.");
		}

		try {
			setSheetName(beanAnnotation.sheetName());
			if (beanAnnotation.retrieveType() == RetrieveType.NONE) {
				setTargetClass(targetClass.getCanonicalName());
			} else {
				ExcelPOJOAnnotationParser parser = new ExcelPOJOAnnotationParser();
				AbstractCellSeeker seeker = buildCellSeeker(beanAnnotation.retrieveType());
				parser.setTargetClass(targetClass.getCanonicalName());
				seeker.set(beanAnnotation, parser);
				setCellSeeker(seeker);
			}
		} catch (Throwable t) {
			throw new ExcelPOJOException(t);
		}
	}

	/**
	 * Excelf[^ǂݍPOJO쐬
	 *
	 * @param file ǂݍݑΏۂExcelt@C
	 * @return 쐬ꂽPOJO
	 * @throws ExcelPOJOException V[gw肳ꂸɌĂяoꂽꍇ
	 */
	public Object load(String file) throws ExcelPOJOException {
		if (getSheetName() == null) {
			throw new ExcelPOJOException("There is no sheet name specified.");
		}
		return load(file, getSheetName());
	}

	/**
	 * Excelf[^ǂݍPOJO쐬<br>
	 * V[gR[fBOɂw肷ꍇɎgp<br>
	 *
	 * @param file ǂݍݑΏۂExcelt@C
	 * @param sheetName V[g
	 * @return 쐬ꂽPOJO
	 * @throws ExcelPOJOException
	 */
	public Object load(String file, String sheetName) throws ExcelPOJOException {
		FileInputStream fileInputStream = null;
		try {
			fileInputStream = new FileInputStream(file);
			return load(fileInputStream, sheetName);
		} catch (ExcelPOJOException e) {
			throw e;
		} catch (Throwable t) {
			throw new ExcelPOJOException(t);
		} finally {
			try { fileInputStream.close(); } catch (Exception e) { }
		}
	}
	/**
	 * Excelf[^ǂݍPOJO쐬<br>
	 * InputStreamɂExcel̃f[^ǂݍލۂɎgp<br>
	 *
	 * @param inputStream Excel̃f[^
	 * @return 쐬ꂽPOJO
	 * @throws ExcelPOJOException
	 */
	public Object load(InputStream inputStream) throws ExcelPOJOException  {
		return load(inputStream, getSheetName());
	}
	/**
	 * Excelf[^ǂݍPOJO쐬<br>
	 * InputStreamɂExcel̃f[^ǂݍލۂɎgp<br>
	 *
	 * @param inputStream Excel̃f[^
	 * @param sheetName V[g
	 * @return 쐬ꂽPOJO
	 * @throws ExcelPOJOException
	 */
	public Object load(InputStream inputStream, String sheetName) throws ExcelPOJOException {
		Object targetBeanInstance;
		try {
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(inputStream));
			HSSFSheet sheet = workBook.getSheet(sheetName);
			if (sheet == null) throw new SheetNotFoundException(sheetName);

			if (getCellSeeker() != null) {
				// \̏ꍇiVerticalRepeats / HorizontalRepeats / MappedCellj
				// VerticalRepeats / HorizontalRepeats ̏ꍇ͌^̎w͒`ɂA
				// MappedCell ̏ꍇMap<String, Object>ŕԂ̂nullw肷B
				return getCellSeeker().seekCellValue(sheet, null);
			}

			Class<?> targetClass = ClassUtils.forName(getTargetClass());

			// Ame[V̏ŕU
			ExcelPOJOAnnotationParser parser = new ExcelPOJOAnnotationParser();
			parser.setTargetClassProperties(getTargetClassProperties(), targetClass);

			targetBeanInstance = Utils.instantiateTarget(getTargetClass());
			for (String propertyName : getTargetClassProperties().keySet()) {
				PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(targetClass, propertyName);
				AbstractCellSeeker cellSeeker = getTargetClassProperties().get(propertyName);

				Object value = cellSeeker.seekCellValue(sheet, propertyDescriptor.getPropertyType());
				ReflectionUtils.invokeMethod(propertyDescriptor.getWriteMethod(),
						targetBeanInstance,
						new Object[]{value});
			}
		} catch (ExcelPOJOException e) {
			throw e;
		} catch (Throwable t) {
			throw new ExcelPOJOException(t);
		}
		return targetBeanInstance;

	}

	/**
	 * POJOExcel֏<br>
	 *
	 * @param inputOutputBookName ݐExcelt@C
	 * @param bean ݏێĂPOJO
	 * @throws ExcelPOJOException
	 */
	public void save(String inputOutputBookName, Object bean) throws ExcelPOJOException {
		save(inputOutputBookName, getSheetName(), inputOutputBookName, bean);
	}
	/**
	 * POJOExcel֏<br>
	 * V[gR[fBOɂw肷ꍇɎgp<br>
	 *
	 * @param inputOutputBookName ݐExcelt@C
	 * @param sheetName V[g
	 * @param bean ݏێĂPOJO
	 * @throws ExcelPOJOException
	 */
	public void save(String inputOutputBookName, String sheetName, Object bean) throws ExcelPOJOException {
		save(inputOutputBookName, sheetName, inputOutputBookName, bean);
	}
	/**
	 * POJOExcel֏<br>
	 * ev[gƂExcelt@Cǂݍ݁A
	 * ʃt@CƂĕۑꍇɎgp<br>
	 * V[gR[fBOɂw肷ꍇɎgp<br>
	 *
	 * @param inputBookName ev[gƂēǂݍExcelt@C
	 * @param sheetName V[g
	 * @param outputBookName ݐExcelt@C
	 * @param bean ݏێĂPOJO
	 * @throws ExcelPOJOException
	 */
	public void save(String inputBookName, String sheetName, String outputBookName, Object bean) throws ExcelPOJOException {
		FileInputStream inputBookStream = null;
		try {
			inputBookStream = new FileInputStream(inputBookName);
			HSSFWorkbook workBook = new HSSFWorkbook(new POIFSFileSystem(inputBookStream));
			save(workBook, sheetName, outputBookName, bean);
		} catch (ExcelPOJOException e) {
			throw e;
		} catch (Throwable t) {
			throw new ExcelPOJOException(t);
		} finally {
			try { inputBookStream.close(); } catch (Exception e) { }
		}
	}
	/**
	 * POJOExcel֏<br>
	 * ev[gƂExcelt@Cǂݍ݁A
	 * ʃt@CƂĕۑꍇɎgp<br>
	 *
	 * @param inputBook ev[gƂēǂݍExcelt@C
	 * @param sheetName V[g
	 * @param outputBookName ݐExcelt@C
	 * @param bean ݏێĂPOJO
	 * @throws ExcelPOJOException w肳ꂽV[g݂Ȃꍇ
	 */
	public void save(HSSFWorkbook inputBook, String sheetName, String outputBookName, Object bean) throws ExcelPOJOException {
		FileOutputStream outputBookStream = null;
		try {
			HSSFSheet sheet = inputBook.getSheet(sheetName);
			if (sheet == null) throw new SheetNotFoundException(sheetName);

			if (getCellSeeker() != null) {
				// List / zA܂ Map ŏ݂ꍇ
				getCellSeeker().setValue(sheet, bean);
			}

			// LList / zA܂ Map ŏ݂ꍇ͉L[v͒ʂȂ
			for (String propertyName : getTargetClassProperties().keySet()) {
				PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(bean.getClass(), propertyName);
				if (propertyDescriptor == null) continue;

				AbstractCellSeeker cellSeeker = getTargetClassProperties().get(propertyName);
				Object value = ReflectionUtils.invokeMethod(propertyDescriptor.getReadMethod(),
						bean,
						new Object[]{});
				cellSeeker.setValue(sheet, value);
			}
			outputBookStream = new FileOutputStream(outputBookName);
			inputBook.write(outputBookStream);
		} catch (ExcelPOJOException e) {
			throw e;
		} catch (Throwable t) {
			throw new ExcelPOJOException(t);
		} finally {
			try { outputBookStream.close(); } catch (Exception e) { }
		}
	}

	public void setSheetName(String sheetName) {
		this.sheetName = sheetName;
	}
	public String getSheetName() {
		return sheetName;
	}

	public void setTargetClass(String targetClass) {
		this.targetClass = targetClass;
	}
	public String getTargetClass() {
		return targetClass;
	}

	public void setTargetClassProperties(HashMap<String, AbstractCellSeeker> targetBeanProperties) {
		this.targetClassProperties = targetBeanProperties;
	}
	public HashMap<String, AbstractCellSeeker> getTargetClassProperties() {
		return targetClassProperties;
	}

	public void setCellSeeker(AbstractCellSeeker cellSeeker) {
		this.cellSeeker = cellSeeker;
	}
	public AbstractCellSeeker getCellSeeker() {
		return cellSeeker;
	}

	private AbstractCellSeeker buildCellSeeker(RetrieveType retrieveType) {
		AbstractCellSeeker seeker = null;
		switch (retrieveType) {
		case LABELED_CELL:
			seeker = new LabeledCellSeeker();
			break;
		case POINTED_CELL:
			seeker = new PointedCellSeeker();
			break;
		case CONSTANT_VALUE:
			seeker = new ConstantValueCellSeeker();
			break;
		case VERTICAL_REPEATS:
			seeker = new VerticalRepeatsSeeker();
			break;
		case HORIZONTAL_REPEATS:
			seeker = new HorizontalRepeatsSeeker();
			break;
		case MAPPED_CELL:
			seeker = new MappedCellSeeker();
			break;
		}

		return seeker;
	}

}
